#!/usr/bin/env python3
############################
# **** IMPORT SECTION **** #
############################
import sys
import os
from qtvcp.core import Status, Path
from qtvcp.lib.qt_vismach.qt_vismach import *
from PyQt5 import QtCore, QtWidgets, QtGui

#import time
#import hal


MINX = hal.get_value("ini.x.min_limit")
MAXX = hal.get_value("ini.x.max_limit")
MINY = hal.get_value("ini.y.min_limit")
MAXY = hal.get_value("ini.y.max_limit")
MINZ = hal.get_value("ini.z.min_limit")
MAXZ = hal.get_value("ini.z.max_limit")

#print (MINX, MAXX, MINY, MAXY, MINZ, MAXZ)

###########################################
# **** instantiate libraries section **** #
###########################################
STATUS = Status()
PATH = Path()

##############################################################################################################################################3
tooltip = Capture()

tool = Collection([
       tooltip,
       Sphere(0, 0, 1, 1),
       CylinderZ(1, 1, 47, 4),
       CylinderZ(47, 4, 150, 4)
       ])
tool = Translate([tool],304, 120, 183)
tool = Color([1,1,0,0.7], [tool] )
tool = HalTranslate([tool],None,"lenght_tool",0,0,1)
tool = HalTranslate([tool], None, "joint.2.pos-fb",0,0,1)
tool = HalTranslate([tool],None, "joint.1.pos-fb",0,1,0)
tool = HalTranslate([tool],None, "joint.0.pos-fb",1,0,0)


## work
work = Capture()
axisa = Collection([ work])  #sztof
axisa = HalRotate([axisa], None, "axis.a.pos-cmd",1,1,0,0,)
axisA = Collection([axisa])
axisA = Translate([axisA],200,445,81)



line = CylinderX(MINX, 1, MAXX, 1)
line = Color([2, 0, 0, 1],[line])
szt1 = Translate([line],MINX,MINY,MAXZ)
szt2 = Translate([line],MINX,MAXY,MAXZ)
szt3 = Translate([line],MINX,MINY,MINZ)
szt4 = Translate([line],MINX,MAXY,MINZ)
linieX = Collection([szt1,szt2, szt3, szt4])
linieX = Rotate([linieX],0,0,0,0)

line2 = CylinderY(MINY, 1, MAXY, 1)
line2 = Color([2, 0, 0, 1],[line2])
szt5 = Translate([line2],MINX,MINY,MAXZ)
szt6 = Translate([line2],MAXX,MINY,MAXZ)
szt7 = Translate([line2],MINX,MINY,MINZ)
szt8 = Translate([line2],MAXX,MINY,MINZ)
linieY = Collection([szt5, szt6, szt7, szt8])
linieY = Rotate([linieY],0,0,0,0)

line3 = CylinderZ(MAXZ, 1, MINZ, 1)
line3 = Color([2, 0, 0, 1],[line3])
szt9 = Translate([line3],MINX,MINY,MAXZ)
szt10 = Translate([line3],MINX,MAXY,MAXZ)
szt11 = Translate([line3],MAXX,MINY,MAXZ)
szt12 = Translate([line3],MAXX,MAXY,MAXZ)
linieZ = Collection([szt9, szt10, szt11, szt12])
linieZ = Rotate([linieZ],0,0,0,0)


pole = Collection([linieX, linieY, linieZ])
pole = Rotate([pole],0,0,0,0)
pole = Translate([pole],305, 120,200)


#work = Capture()
base = Collection([pole,  axisA])  # bed, atc
model = Collection([base, tool])
model = Rotate([model],150,0,0,40)
model = Translate([model],850,0,-20)

#uncomment for a DRO HUD
myhud = HalHud()
myhud.set_background_color(0,.0,0,1)
#myhud.show_top("machine-test")
#myhud.show_top("------------")
myhud.add_pin('axis X: ',"{:10.3f}","axis.x.pos-cmd")
myhud.add_pin('axis Y: ',"{:10.3f}","axis.y.pos-cmd")
myhud.add_pin('axis Z: ',"{:10.3f}","axis.z.pos-cmd")
myhud.add_pin('axis A: ',"{:10.3f}","axis.a.pos-cmd")
myhud.show("")

###########################################
# model window                            #
###########################################

# we want to embed with qtvcp so build a window to display
# the model
class VisWindow(QWidget):

    def __init__(self):
        super(VisWindow, self).__init__()
        self.glWidget = GLWidget()
        v = self.glWidget
        v.set_latitudelimits( -180, 180)

        v.hud = myhud
        # HUD needs to know where to draw
        v.hud.app = v

        world = Capture()

        v.model = Collection([model, world])
        size = 1000
        v.distance = size * 2.5
        v.near = size * 0.05
        v.far = size * 10.0
        v.tool2view = tooltip
        v.world2view = world
        v.work2view = work

        mainLayout = QHBoxLayout()
        mainLayout.setContentsMargins(0,0,0,0)
        mainLayout.addWidget(self.glWidget)
        self.setLayout(mainLayout)


###########################################
# **** instantiate libraries section **** #
###########################################
#STATUS = Status()

###################################
# **** HANDLER CLASS SECTION **** #
###################################


class HandlerClass:

    ########################
    # **** INITIALIZE **** #
    ########################
    # widgets allows access to  widgets from the qtvcp files
    # at this point the widgets and hal pins are not instantiated
    def __init__(self, halcomp,widgets,paths):
        self.w = widgets
###        self.endcolor()

    ##########################################
    # Special Functions called from QTVCP
    ##########################################

    # at this point:
    # the widgets are instantiated.
    # the HAL pins are built but HAL is not set ready
    def initialized__(self):
        machine = VisWindow()
        self.w.mainLayout.addWidget(machine)


#    def initialized__(self):
#        MojaKlasa()
#        self.w.mainLayout.addWidget(machine)



#    def endcolor(self):
#        self.timer = QtCore.QTimer()
#        self.timer.timeout.connect(self.printa)
#        self.timer.start(1000)


    ########################
    # callbacks from STATUS #
    ########################

    #######################
    # callbacks from form #
    #######################

    #####################
    # general functions #
    #####################

    #####################
    # KEY BINDING CALLS #
    #####################

    ###########################
    # **** closing event **** #
    ###########################

    ##############################
    # required class boiler code #
    ##############################

#    def __getitem__(self, item):
#        return getattr(self, item)
#    def __setitem__(self, item, value):
#        return setattr(self, item, value)

################################
# required handler boiler code #
################################

def get_handlers(halcomp,widgets,paths):
     return [HandlerClass(halcomp,widgets,paths)]


