#!/usr/bin/env python3
import os
import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, GdkPixbuf
from linuxcnc import command

class RechtecktaschePlugin(Gtk.Box):
    def __init__(self, app):
        super().__init__()
        self.app = app
        self.set_orientation(Gtk.Orientation.VERTICAL)
        self.set_spacing(6)

        # Bild / Diagramm
        img_path = os.path.join(os.path.dirname(__file__), "../../widgets/rechtecktasche/diagram.png")
        if os.path.exists(img_path):
            pixbuf = GdkPixbuf.Pixbuf.new_from_file_at_scale(img_path, 300, 200, True)
            image = Gtk.Image.new_from_pixbuf(pixbuf)
        else:
            image = Gtk.Label(label="Diagramm Rechtecktasche")
        self.pack_start(image, False, False, 0)

        # Parameterfelder
        self.entries = {}
        for label_text in ["X-Start", "Y-Start", "Länge X", "Breite Y", "Tiefe", "Eckenradius", "Werkzeug"]:
            self.pack_start(Gtk.Label(label=label_text), False, False, 0)
            entry = Gtk.SpinButton()
            entry.set_range(0, 500)
            entry.set_value(0)
            self.entries[label_text] = entry
            self.pack_start(entry, False, False, 0)

        # Button
        button = Gtk.Button(label="Makro ausführen")
        button.connect("clicked", self.run_macro)
        self.pack_start(button, False, False, 0)

    def run_macro(self, widget):
        x = self.entries["X-Start"].get_value()
        y = self.entries["Y-Start"].get_value()
        xl = self.entries["Länge X"].get_value()
        yl = self.entries["Breite Y"].get_value()
        t = self.entries["Tiefe"].get_value()
        e = self.entries["Eckenradius"].get_value()
        tool = self.entries["Werkzeug"].get_value()

        macro_file = os.path.join(os.path.dirname(__file__), "rechtecktasche.ngc")
        if not os.path.exists(macro_file):
            Gtk.MessageDialog(None, 0, Gtk.MessageType.ERROR,
                Gtk.ButtonsType.OK, "Makro-Datei nicht gefunden").run()
            return

        with open(macro_file, "r") as f:
            code = f.read()

        code = code.replace("[X]", str(x)).replace("[Y]", str(y))
        code = code.replace("[XL]", str(xl)).replace("[YL]", str(yl))
        code = code.replace("[T]", str(t))
        code = code.replace("[E]", str(e))
        code = code.replace("[TOOL]", str(int(tool)))

        cmd = command()
        cmd.mode = 'MACHINE'
        cmd.load(code)
        cmd.execute()
