#!/usr/bin/env python3
import tkinter as tk
from tkinter import ttk
from tkinter import messagebox
from PIL import Image, ImageTk
import pyperclip

# Bildpfad (falls Bild vorhanden)
bild_pfad = "/home/mh500cnc/linuxcnc/configs/mh500cnc/user_programs/widgets/tasche.png"

def feld_pruefen(entry):
    """Überprüft Feld auf gültigen Wert"""
    try:
        val = float(entry.get())
        entry.config(background="white")
        return val
    except ValueError:
        entry.config(background="red")
        return None

def generiere_gcode():
    x = feld_pruefen(entry_x)
    y = feld_pruefen(entry_y)
    t = feld_pruefen(entry_t)
    r = feld_pruefen(entry_r)
    abstand = feld_pruefen(entry_s)
    werkzeug = entry_w.get()
    ref = entry_ref.get()
    eintauch = dropdown_eintauch.get()
    
    # Prüfen, ob alles gültig ist
    if None in [x,y,t,r,abstand] or not werkzeug or not ref:
        messagebox.showerror("Fehler", "Bitte alle Felder korrekt ausfüllen!")
        return
    
    # Beispiel-G-Code basierend auf LinuxCNC Rechtecktaschen-Zyklus
    gcode = f"""O100 sub ; Rechtecktasche parametrisch
#1 = {x}
#2 = {y}
#3 = {t}
#4 = {r} ; Eckenradius
#5 = {abstand} ; Sicherheitsabstand
; Werkzeug = {werkzeug}, Referenz = {ref}, Eintauchart = {eintauch}

G0 Z5
G0 X0 Y0
"""
    if eintauch == "gerade":
        gcode += f"G1 Z-#3 F100\n"
    elif eintauch == "zickzack":
        gcode += f"; Zick-Zack Eintauchen\nG1 Z-#3 F100\n"
    elif eintauch == "helix":
        gcode += f"; Helix Eintauchen\nG1 Z-#3 F100\n"

    gcode += f"""G1 X#1 F200
G1 Y#2
G1 X0
G1 Y0
G0 Z5
O100 endsub
"""
    pyperclip.copy(gcode)
    messagebox.showinfo("G-Code kopiert", "Der G-Code wurde in die Zwischenablage kopiert.")

# GUI
root = tk.Tk()
root.title("Rechtecktasche")

frame_links = ttk.Frame(root, padding=10)
frame_links.grid(row=0, column=0, sticky="n")
frame_rechts = ttk.Frame(root, padding=10)
frame_rechts.grid(row=0, column=1, sticky="n")

# Eingabefelder
ttk.Label(frame_links, text="X-Länge:").grid(row=0, column=0, sticky="w")
entry_x = ttk.Entry(frame_links)
entry_x.grid(row=0, column=1)

ttk.Label(frame_links, text="Y-Breite:").grid(row=1, column=0, sticky="w")
entry_y = ttk.Entry(frame_links)
entry_y.grid(row=1, column=1)

ttk.Label(frame_links, text="Tiefe (T):").grid(row=2, column=0, sticky="w")
entry_t = ttk.Entry(frame_links)
entry_t.grid(row=2, column=1)

ttk.Label(frame_links, text="Eckenradius:").grid(row=3, column=0, sticky="w")
entry_r = ttk.Entry(frame_links)
entry_r.grid(row=3, column=1)

ttk.Label(frame_links, text="Werkzeug:").grid(row=4, column=0, sticky="w")
entry_w = ttk.Entry(frame_links)
entry_w.grid(row=4, column=1)

ttk.Label(frame_links, text="Sicherheitsabstand:").grid(row=5, column=0, sticky="w")
entry_s = ttk.Entry(frame_links)
entry_s.grid(row=5, column=1)

ttk.Label(frame_links, text="Referenzpunkt:").grid(row=6, column=0, sticky="w")
entry_ref = ttk.Entry(frame_links)
entry_ref.grid(row=6, column=1)

ttk.Label(frame_links, text="Eintauchart:").grid(row=7, column=0, sticky="w")
dropdown_eintauch = ttk.Combobox(frame_links, values=["gerade","zickzack","helix"])
dropdown_eintauch.grid(row=7, column=1)
dropdown_eintauch.current(0)

# Button
btn_kopieren = ttk.Button(frame_links, text="G-Code kopieren", command=generiere_gcode)
btn_kopieren.grid(row=8, column=0, columnspan=2, pady=10)

# Bild
try:
    img = Image.open(bild_pfad)
    img = img.resize((300,200))
    photo = ImageTk.PhotoImage(img)
    label_img = ttk.Label(frame_rechts, image=photo)
    label_img.image = photo
    label_img.grid(row=0, column=0)
except Exception:
    ttk.Label(frame_rechts, text="Bild konnte nicht geladen werden").grid(row=0, column=0)

root.mainloop()
